/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BackpackShapes {
    public static final IShapeProvider DEFAULT_SHAPE_PROVIDER;
    private static IShapeProvider shapeProvider;

    private BackpackShapes() {
    }

    public static void setShapeProvider(IShapeProvider provider) {
        shapeProvider = provider;
    }

    public static VoxelShape getShape(Block backpackBlock, Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
        return shapeProvider.getShape(backpackBlock, dir, leftTank, rightTank, battery);
    }

    public static VoxelShape or(Stream<VoxelShape> shapes) {
        return shapes.reduce((v1, v2) -> Shapes.m_83148_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).map(VoxelShape::m_83296_).orElse(Shapes.m_83040_());
    }

    static {
        shapeProvider = DEFAULT_SHAPE_PROVIDER = new IShapeProvider(){
            private static final Map<Integer, VoxelShape> SHAPES = new HashMap<Integer, VoxelShape>();
            private static final RotatedShapes BODY = new RotatedShapes(Block.m_49796_((double)5.25, (double)0.0, (double)4.0, (double)5.75, (double)12.5, (double)5.0), Block.m_49796_((double)4.25, (double)0.0, (double)4.0, (double)5.25, (double)12.5, (double)5.0), Block.m_49796_((double)3.75, (double)0.0, (double)4.0, (double)4.25, (double)12.5, (double)5.0), Block.m_49796_((double)10.25, (double)0.0, (double)4.0, (double)10.75, (double)12.5, (double)5.0), Block.m_49796_((double)10.75, (double)0.0, (double)4.0, (double)11.75, (double)12.5, (double)5.0), Block.m_49796_((double)11.75, (double)0.0, (double)4.0, (double)12.25, (double)12.5, (double)5.0), Block.m_49796_((double)4.25, (double)8.25, (double)11.0, (double)11.75, (double)9.25, (double)11.25), Block.m_49796_((double)11.75, (double)8.25, (double)5.25, (double)12.75, (double)13.25, (double)11.25), Block.m_49796_((double)4.25, (double)9.25, (double)5.25, (double)11.75, (double)13.25, (double)11.25), Block.m_49796_((double)3.25, (double)8.25, (double)5.25, (double)4.25, (double)13.25, (double)11.25), Block.m_49796_((double)5.75, (double)13.25, (double)7.25, (double)6.5, (double)14.0, (double)8.25), Block.m_49796_((double)5.75, (double)14.0, (double)7.25, (double)10.25, (double)14.5, (double)8.25), Block.m_49796_((double)9.5, (double)13.25, (double)7.25, (double)10.25, (double)14.0, (double)8.25), Block.m_49796_((double)4.5, (double)9.0, (double)4.75, (double)5.5, (double)13.5, (double)11.5), Block.m_49796_((double)4.5, (double)7.0, (double)10.75, (double)5.5, (double)9.0, (double)11.5), Block.m_49796_((double)10.5, (double)9.0, (double)4.75, (double)11.5, (double)13.5, (double)11.5), Block.m_49796_((double)10.5, (double)7.0, (double)10.75, (double)11.5, (double)9.0, (double)11.5), Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)13.0, (double)11.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.5, (double)12.0, (double)12.0, (double)5.0));
            private static final RotatedShapes BATTERY = new RotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0, (double)14.0), Block.m_49796_((double)6.0, (double)5.25, (double)11.5, (double)7.0, (double)6.25, (double)12.5), Block.m_49796_((double)7.25, (double)5.25, (double)11.5, (double)8.25, (double)6.25, (double)12.5), Block.m_49796_((double)6.0, (double)7.0, (double)10.25, (double)7.0, (double)8.0, (double)11.25), Block.m_49796_((double)7.25, (double)7.0, (double)10.25, (double)8.25, (double)8.0, (double)11.25), Block.m_49796_((double)6.199999999999999, (double)5.6, (double)11.7, (double)6.800000000000001, (double)7.2, (double)12.3), Block.m_49796_((double)6.199999999999999, (double)7.2, (double)10.7, (double)6.800000000000001, (double)7.8, (double)12.3), Block.m_49796_((double)7.449999999999999, (double)5.6, (double)11.7, (double)8.05, (double)7.2, (double)12.3), Block.m_49796_((double)7.449999999999999, (double)7.2, (double)10.7, (double)8.05, (double)7.8, (double)12.3), Block.m_49796_((double)8.8, (double)4.05, (double)12.95, (double)10.2, (double)5.45, (double)14.35), Block.m_49796_((double)8.8, (double)0.05, (double)12.95, (double)10.2, (double)1.45, (double)14.35), Block.m_49796_((double)11.25, (double)4.25, (double)10.25, (double)12.25, (double)5.25, (double)14.25), Block.m_49796_((double)4.5, (double)4.25, (double)13.25, (double)11.5, (double)5.25, (double)14.25), Block.m_49796_((double)3.75, (double)4.25, (double)10.25, (double)4.75, (double)5.25, (double)14.25), Block.m_49796_((double)11.25, (double)0.25, (double)10.25, (double)12.25, (double)1.25, (double)14.25), Block.m_49796_((double)4.5, (double)0.25, (double)13.25, (double)11.5, (double)1.25, (double)14.25), Block.m_49796_((double)3.75, (double)0.25, (double)10.25, (double)4.75, (double)1.25, (double)14.25));
            private static final RotatedShapes LEFT_TANK = new RotatedShapes(Block.m_49796_((double)2.5, (double)1.5, (double)6.0, (double)3.5, (double)7.5, (double)10.0), Block.m_49796_((double)0.5, (double)10.5, (double)6.5, (double)3.5, (double)11.5, (double)9.5), Block.m_49796_((double)0.0, (double)9.5, (double)6.0, (double)3.0, (double)10.5, (double)10.0), Block.m_49796_((double)0.0, (double)8.5, (double)6.0, (double)3.0, (double)9.5, (double)10.0), Block.m_49796_((double)0.0, (double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)10.0), Block.m_49796_((double)0.0, (double)0.5, (double)6.0, (double)3.0, (double)1.5, (double)10.0), Block.m_49796_((double)0.5, (double)1.5, (double)6.5, (double)2.5, (double)7.5, (double)9.5));
            private static final RotatedShapes RIGHT_TANK = new RotatedShapes(Block.m_49796_((double)12.5, (double)1.5, (double)6.0, (double)13.5, (double)7.5, (double)10.0), Block.m_49796_((double)12.5, (double)10.5, (double)6.5, (double)15.5, (double)11.5, (double)9.5), Block.m_49796_((double)13.0, (double)9.5, (double)6.0, (double)16.0, (double)10.5, (double)10.0), Block.m_49796_((double)13.0, (double)8.5, (double)6.0, (double)16.0, (double)9.5, (double)10.0), Block.m_49796_((double)13.0, (double)7.5, (double)6.0, (double)16.0, (double)8.5, (double)10.0), Block.m_49796_((double)13.0, (double)0.5, (double)6.0, (double)16.0, (double)1.5, (double)10.0), Block.m_49796_((double)13.5, (double)1.5, (double)6.5, (double)15.5, (double)7.5, (double)9.5));
            private static final RotatedShapes LEFT_POUCHES = new RotatedShapes(Block.m_49796_((double)1.0, (double)2.0, (double)5.5, (double)3.0, (double)6.0, (double)10.5), Block.m_49796_((double)1.0, (double)1.0, (double)5.5, (double)3.0, (double)2.0, (double)10.5), Block.m_49796_((double)1.0, (double)0.0, (double)5.5, (double)3.0, (double)1.0, (double)10.5), Block.m_49796_((double)0.75, (double)3.0, (double)7.5, (double)1.0, (double)5.0, (double)8.5), Block.m_49796_((double)1.0, (double)4.0, (double)5.5, (double)3.0, (double)5.0, (double)10.5), Block.m_49796_((double)2.0, (double)7.0, (double)5.5, (double)3.0, (double)11.0, (double)10.5), Block.m_49796_((double)1.75, (double)8.0, (double)7.5, (double)2.0, (double)10.0, (double)8.5), Block.m_49796_((double)2.0, (double)9.0, (double)5.5, (double)4.0, (double)10.0, (double)10.5));
            private static final RotatedShapes RIGHT_POUCHES = new RotatedShapes(Block.m_49796_((double)13.0, (double)2.0, (double)5.5, (double)15.0, (double)6.0, (double)10.5), Block.m_49796_((double)13.0, (double)1.0, (double)5.5, (double)15.0, (double)2.0, (double)10.5), Block.m_49796_((double)13.0, (double)0.0, (double)5.5, (double)15.0, (double)1.0, (double)10.5), Block.m_49796_((double)15.0, (double)3.0, (double)7.5, (double)15.25, (double)5.0, (double)8.5), Block.m_49796_((double)13.0, (double)4.0, (double)5.5, (double)15.0, (double)5.0, (double)10.5), Block.m_49796_((double)13.0, (double)7.0, (double)5.5, (double)14.0, (double)11.0, (double)10.5), Block.m_49796_((double)14.0, (double)8.0, (double)7.5, (double)14.25, (double)10.0, (double)8.5), Block.m_49796_((double)12.0, (double)9.0, (double)5.5, (double)14.0, (double)10.0, (double)10.5));
            private static final RotatedShapes FRONT_POUCH = new RotatedShapes(Block.m_49796_((double)4.0, (double)2.0, (double)11.0, (double)12.0, (double)6.0, (double)13.0), Block.m_49796_((double)4.0, (double)1.0, (double)11.0, (double)12.0, (double)2.0, (double)13.0), Block.m_49796_((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)13.0), Block.m_49796_((double)5.0, (double)3.0, (double)13.0, (double)6.0, (double)5.0, (double)13.25), Block.m_49796_((double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)5.0, (double)13.25), Block.m_49796_((double)4.0, (double)4.0, (double)11.0, (double)12.0, (double)5.0, (double)13.0));

            @Override
            public VoxelShape getShape(Block backpackBlock, Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
                int key = 1.getKey(dir, leftTank, rightTank, battery);
                return SHAPES.computeIfAbsent(key, k -> 1.composeShape(dir, leftTank, rightTank, battery));
            }

            private static VoxelShape composeShape(Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
                ArrayList<RotatedShapes> shapes = new ArrayList<RotatedShapes>();
                shapes.add(BODY);
                shapes.add(leftTank ? LEFT_TANK : LEFT_POUCHES);
                shapes.add(rightTank ? RIGHT_TANK : RIGHT_POUCHES);
                shapes.add(battery ? BATTERY : FRONT_POUCH);
                return BackpackShapes.or(shapes.stream().map(r -> r.getRotatedShape(dir)));
            }

            private static int getKey(Direction dir, boolean leftTank, boolean rightTank, boolean battery) {
                return dir.m_122416_() << 3 | 1.b2i(leftTank) << 2 | 1.b2i(rightTank) << 1 | 1.b2i(battery);
            }

            private static int b2i(boolean value) {
                return value ? 1 : 0;
            }
        };
    }

    public static interface IShapeProvider {
        public VoxelShape getShape(Block var1, Direction var2, boolean var3, boolean var4, boolean var5);
    }

    public static class RotatedShapes {
        private final VoxelShape[] rotatedShapes = new VoxelShape[4];

        public RotatedShapes(VoxelShape ... shapes) {
            this.rotatedShapes[0] = BackpackShapes.or(Stream.of(shapes));
        }

        public VoxelShape getRotatedShape(Direction to) {
            int index = (to.m_122416_() + 4) % 4;
            if (this.rotatedShapes[index] == null) {
                for (int i = 1; i <= index; ++i) {
                    if (this.rotatedShapes[i] != null) continue;
                    this.rotatedShapes[i] = RotatedShapes.rotateShapeOnce(this.rotatedShapes[i - 1]);
                }
            }
            return this.rotatedShapes[index];
        }

        private static VoxelShape rotateShapeOnce(VoxelShape shape) {
            ArrayList shapes = new ArrayList();
            shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> shapes.add(Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX)));
            return BackpackShapes.or(shapes.stream());
        }
    }
}

